#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"
// LIST OF PRECOMPUTED SYSTEM PARAMETERS

#define KAZ_DS_SP_G				"6007"
#define KAZ_DS_SP_R				"6151"

#define KAZ_DS_SP_Q				"15805027320208803894072603145771831246637343495"
#define KAZ_DS_SP_q				"5708990770823839524233143877797980545530986749"

#define KAZ_DS_SP_G0			"23102151283542472555351033031857407110549489214984451103786304558150674606117088000"
#define KAZ_DS_SP_LG0			274

#define KAZ_DS_SP_G1			"399620650696124709852000"
#define KAZ_DS_SP_LG1			79

#define KAZ_DS_SP_qQ			"90230755103690702091973211007922974222612910553804250618499942113585284663920884979406347755"

#define KAZ_DS_SP_G1Q			"6316015301971870405355111523122642561944284008905299941124934612740000"
#define KAZ_DS_SP_G1qQ			"36058073067339553985234252533698355039820968917784402221504061489000889035129447518174352692951449576156386582260000"

#define KAZ_DS_SP_PHIG1			"60408037934094090240000"
#define KAZ_DS_SP_PHIPHIG1		"11456568251237007360000"
#define KAZ_DS_SP_PHIQ			"3627887299833526965332723467399389511680000000"
#define KAZ_DS_SP_PHIqQ			"20711575112338624928696946102003619446749681847468928622048198130495376119592271216640000000"

#define KAZ_DS_SP_RAN			4
#define KAZ_DS_SP_A				"324324000"

#define KAZ_DS_SP_J				192
#define KAZ_DS_SP_K				192
#define KAZ_DS_SP_RHO			"6958035260797738325821571123874890883325854356506953926147"
#define KAZ_DS_SP_G1RHO 		"2780574578486571985357538778664475851603942045856011006180329605609412611300244000"
#define KAZ_DS_SP_LG1RHO		271
#define KAZ_DS_SP_G1QRHO 		"43947057178858349281469823683456747837008964566213302341175642613858213234180124996235330169158835649866435645207198005312780000"
#define KAZ_DS_SP_G1qQRHO		"250893343838969877863024788106342431306813468937412573541937672939465921301334865939583469036925555704399706518309911896437823276514950457299755576516752580105417780352220000"
#define KAZ_DS_SP_PHIG1RHO		"420321257981034043095252041957047171374281436264017174140026587278944019415040000"
#define KAZ_DS_SP_PHIPHIG1RHO	"39857602929921489702080944341648626696561074583376366185880680612910512209920000"

#define KAZ_DS_SKBYTES			73
#define KAZ_DS_V1BYTES			34
#define KAZ_DS_V2BYTES			39
#define KAZ_DS_S1BYTES			73 // S1=73 bytes
#define KAZ_DS_S2BYTES			8 // S2=8 bytes

extern void KAZ_DS_CRT(int t, mpz_t *c, mpz_t *modular, mpz_t crt);

extern void KAZ_DS_KEYGEN(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
							   const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);

#endif // FILE_H_INCLUDED
